/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.client;

import com.ibm.hsc.cim.client.HSCSendSignalClt;
import com.ibm.hsc.client.CDThreadPool;
import com.ibm.hsc.common.util.HscPasswordMgr;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMProperty;

public class CecDiscoveryClient {
    private static final int RC_SUCCESS = 0;
    private static final int RC_FAILURE = 1;
    private static final int VALIDATE_DOTTED_IP_FORM = 1;
    private static final int VALIDATE_SUBNETS_MATCH = 2;
    private static final int VALIDATE_RANGE_SPAN = 3;
    private static final int PARSE_SUBNET = 1;
    private static final int PARSE_LAST = 2;
    private Hashtable _hmcNetCfgHosts = null;
    private Hashtable _hmcNetCfgIps = null;
    private Hashtable _hmcNetCfgUnreachable = null;
    private CDThreadPool _tPool = null;

    private void debug(String string) {
        System.out.println("| DiscoveryClient." + string);
    }

    public Vector discoverFrames(String string, String string2) {
        return this.discoverCecs(string, string2, 1);
    }

    public Vector discoverCecs(String string, String string2) {
        return this.discoverCecs(string, string2, 0);
    }

    private Vector discoverCecs(String string, String string2, int n) {
        long l = System.currentTimeMillis();
        String string3 = null;
        Vector vector = null;
        Vector<Object> vector2 = new Vector<Object>(2);
        int n2 = 60;
        vector2.setSize(2);
        this._tPool = null;
        this.debug("discoverCecs(). begIP=" + string + ", endIP=" + string2);
        string3 = this.validateRange(string, string2);
        if (string3 != null) {
            vector2.set(0, string3);
            vector2.set(1, vector);
            return vector2;
        }
        IpData ipData = this.parseIP(string);
        IpData ipData2 = this.parseIP(string2);
        String string4 = ipData.subNet;
        int n3 = ipData.n4;
        int n4 = ipData2.n4;
        this.refreshMgdCecsList();
        int n5 = this.setPoolSize(n3, n4);
        this._tPool = CDThreadPool.create(n5, 0);
        this._tPool.printTimeStamp("CDClient:Starting - Just created thread pool...");
        for (int i = n3; i <= n4; ++i) {
            String string5 = string4 + "." + i;
            this.debug("Checking " + string5);
            if (this.alreadyManaged(string5)) {
                this.debug("ALREADY managed...");
                continue;
            }
            this.debug("CDClient:  NOT already managed...");
            String[] stringArray = new String[]{string5, "" + n2, "" + n};
            this.debug("SUBMITTING ipaddr = " + stringArray[0]);
            this._tPool.cmdRequest(stringArray);
        }
        this._tPool.doneSubmittingCmds();
        this.debug("done submitting cmds...");
        this._tPool.waitUntilAllFinished(n2);
        this._tPool.printTimeStamp("FINISHED - after waitUntilAllFinised returned...");
        this.debug("All cmds finished...");
        vector = this._tPool.getResultData();
        vector2.set(0, string3);
        vector2.set(1, vector);
        this._tPool.stopAll();
        CecDiscoveryClient.dumpDiscResults(vector2);
        long l2 = System.currentTimeMillis();
        this._tPool.printTimeDiff("Exiting discoverCecs - TOTAL TIME in discoverCecs: ", l2 - l);
        this._tPool = null;
        return vector2;
    }

    public Vector addCecs(Vector vector) {
        return this.addCecs(vector, 0);
    }

    public Vector addFrames(Vector vector) {
        return this.addCecs(vector, 1);
    }

    private Vector addCecs(Vector vector, int n) {
        int n2 = 0;
        String string = "";
        Vector<Object> vector2 = new Vector<Object>(2);
        vector2.setSize(2);
        if (vector != null) {
            boolean bl = false;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Vector vector3;
                String[] stringArray = (String[])iterator.next();
                this.debug("next IP [0] = " + stringArray[0]);
                bl = false;
                String string2 = stringArray[0];
                try {
                    vector3 = this.parseIP(stringArray[0]);
                    if (((IpData)((Object)vector3)).rc == 0) {
                        string2 = ((IpData)((Object)vector3)).n1 + "." + ((IpData)((Object)vector3)).n2 + "." + ((IpData)((Object)vector3)).n3 + "." + ((IpData)((Object)vector3)).n4;
                        this.debug("Normalized IP addr = " + string2);
                        bl = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!bl) {
                    try {
                        string2 = this.convToHostName(string2);
                    }
                    catch (Throwable throwable) {
                        n2 = 1;
                    }
                }
                this.refreshMgdCecsList();
                if (this.alreadyManaged(string2)) {
                    string = string + "IP address " + stringArray[0] + " is already managed by this HMC.";
                    this.debug("ALREADY managed...");
                    continue;
                }
                vector3 = new Vector();
                int n3 = CecDiscoveryClient.addSingleCec(stringArray[0], stringArray[1], vector3, n);
                if (n3 == 0) continue;
                n2 = 1;
                string = string + (String)vector3.elementAt(0) + "\n";
            }
        }
        vector2.set(0, new Integer(n2));
        vector2.set(1, string);
        this.debug("returning vector = " + vector2);
        return vector2;
    }

    public Vector stopAll() {
        Vector<Object> vector = new Vector<Object>();
        vector.setSize(2);
        Vector vector2 = null;
        try {
            vector.set(0, "Prematurely stopped command.");
            this._tPool.stopAll();
            vector2 = this._tPool.getResultData();
            if (vector2 == null) {
                vector2 = new Vector();
            }
            vector.set(1, vector2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return vector;
    }

    private String convToHostName(String string) throws Throwable {
        if (string == null) {
            return string;
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        string = inetAddress.getHostAddress();
        return string;
    }

    private static int addSingleCec(String string, String string2, Vector vector, int n) {
        HSCSendSignalClt hSCSendSignalClt = HSCSendSignalClt.getInstance(null, null);
        int n2 = 0;
        int n3 = 221;
        int n4 = 1;
        n4 = string2 != null ? 3 : 2;
        Vector<String> vector2 = new Vector<String>(n4);
        vector2.addElement(string);
        if (string2 != null) {
            vector2.addElement(string2);
        }
        vector2.addElement(Integer.toString(n));
        String string3 = HscPasswordMgr.getHscUser();
        String string4 = HscPasswordMgr.getCredentialKey(string3);
        try {
            n2 = hSCSendSignalClt.sendSignal(n3, vector2, string3, string4);
        }
        catch (CIMException cIMException) {
            vector.addElement("Failed adding IP address:  " + string);
            cIMException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            vector.addElement("Failed adding IP address:  " + string);
        }
        return n2;
    }

    private IpData parseIP(String string) {
        this.debug("parseIP for " + string);
        IpData ipData = new IpData();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        this.debug("ip tokens=" + n);
        if (n != 4) {
            this.debug("Error:  Invalid IP address entered:  " + string);
            ipData.errMsg = "Error:  Invalid IP address entered:  " + string;
            ipData.rc = 1;
        }
        ipData.n1Str = stringTokenizer.nextToken();
        ipData.n2Str = stringTokenizer.nextToken();
        ipData.n3Str = stringTokenizer.nextToken();
        ipData.n4Str = stringTokenizer.nextToken();
        try {
            ipData.n1 = Integer.parseInt(ipData.n1Str);
            ipData.n2 = Integer.parseInt(ipData.n2Str);
            ipData.n3 = Integer.parseInt(ipData.n3Str);
            ipData.n4 = Integer.parseInt(ipData.n4Str);
        }
        catch (NumberFormatException numberFormatException) {
            this.debug("Error:  Invalid IP address entered:  " + string);
            ipData.errMsg = "Error:  Invalid IP address (invalid numeric format) entered:  " + string;
            ipData.rc = 1;
        }
        if (ipData.n1 < 0 || ipData.n1 > 255 || ipData.n2 < 0 || ipData.n2 > 255 || ipData.n3 < 0 || ipData.n3 > 255 || ipData.n4 < 0 || ipData.n4 > 255) {
            ipData.errMsg = "Error:  invalid IP address.  Each IP address component must be 0 <= n <= 255.";
            ipData.rc = 1;
        }
        ipData.subNet = ipData.n1 + "." + ipData.n2 + "." + ipData.n3;
        return ipData;
    }

    private String validateCondition(int n, String string, String string2) {
        String string3 = null;
        IpData ipData = this.parseIP(string);
        IpData ipData2 = null;
        switch (n) {
            case 1: {
                if (ipData.rc != 1) break;
                string3 = ipData.errMsg;
                break;
            }
            case 2: {
                ipData2 = this.parseIP(string2);
                if (ipData.subNet.equals(ipData2.subNet)) break;
                string3 = "Error:  Subnets don't match.  Both IP addresses entered must be on the same subnet.";
                break;
            }
            case 3: {
                ipData2 = this.parseIP(string2);
                if (ipData.n1 < 0 || ipData.n1 > 255) {
                    string3 = "Error:  IP address is out of valid range 0-255:  " + ipData;
                }
                if (ipData2.n1 < 0 || ipData2.n1 > 255) {
                    string3 = "Error:  IP address is out of valid range 0-255:  " + ipData2;
                }
                if (ipData.n4 <= ipData2.n4) break;
                string3 = "Error:  beginning range cannot start after ending range.";
                break;
            }
        }
        return string3;
    }

    private String validateRange(String string, String string2) {
        String string3 = null;
        string3 = this.validateCondition(1, string, null);
        if (string3 != null) {
            return string3;
        }
        string3 = this.validateCondition(1, string2, null);
        if (string3 != null) {
            return string3;
        }
        string3 = this.validateCondition(2, string, string2);
        if (string3 != null) {
            return string3;
        }
        string3 = this.validateCondition(3, string, string2);
        if (string3 != null) {
            return string3;
        }
        return null;
    }

    private boolean alreadyManaged(String string) {
        boolean bl = false;
        this.debug("Checking if already managed, ipAddr = " + string);
        if (string == null) {
            return false;
        }
        if (this._hmcNetCfgIps != null && this._hmcNetCfgIps.get(string) != null) {
            bl = true;
        }
        if (this._hmcNetCfgHosts != null && this._hmcNetCfgHosts.get(string) != null) {
            bl = true;
        }
        if (this._hmcNetCfgUnreachable != null && this._hmcNetCfgUnreachable.get(string) != null) {
            bl = true;
        }
        return bl;
    }

    private void refreshMgdCecsList() {
        try {
            this.debug("NEW refreshMgdCecsList...");
            HSCSendSignalClt hSCSendSignalClt = HSCSendSignalClt.getInstance(null, null);
            int n = 230;
            String string = HscPasswordMgr.getHscUser();
            String string2 = HscPasswordMgr.getCredentialKey(string);
            Vector vector = new Vector();
            int n2 = hSCSendSignalClt.sendSignal(n, null, vector, string, string2);
            if (n2 != 0) {
                this.debug("Nonzero rc from signal 230, rc= " + n2 + " RETURNING ...");
                return;
            }
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
            Vector vector2 = (Vector)cIMProperty.getValue().getValue();
            if (vector2.size() < 3) {
                this.debug("Size of vector back indicates no data, size= " + vector2.size() + " RETURNING ...");
                return;
            }
            for (int i = 0; i < vector2.size(); i += 3) {
                String string3 = (String)vector2.elementAt(i);
                String string4 = (String)vector2.elementAt(i + 1);
                String string5 = (String)vector2.elementAt(i + 2);
                if (this._hmcNetCfgHosts == null) {
                    this._hmcNetCfgHosts = new Hashtable();
                }
                if (this._hmcNetCfgIps == null) {
                    this._hmcNetCfgIps = new Hashtable();
                }
                if (this._hmcNetCfgUnreachable == null) {
                    this._hmcNetCfgUnreachable = new Hashtable();
                }
                if (!string3.equals("-")) {
                    this._hmcNetCfgHosts.put(string3, string4);
                }
                if (!string4.equals("-")) {
                    this._hmcNetCfgIps.put(string4, string3);
                }
                if (string5.equals("-")) continue;
                this._hmcNetCfgUnreachable.put(string5, "");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.debug("ip list=" + this._hmcNetCfgIps + " ,host list=" + this._hmcNetCfgHosts + " , unreachable list=" + this._hmcNetCfgUnreachable);
    }

    private int setPoolSize(int n, int n2) {
        int n3;
        int n4 = 2;
        int n5 = 10;
        int n6 = n3 = n2 - n;
        if (n3 < n4) {
            n6 = n4;
        } else if (n3 > n5) {
            n6 = n5;
        }
        return n6;
    }

    public static void dumpDiscResults(Vector vector) {
        try {
            if (vector != null) {
                String string = (String)vector.elementAt(0);
                System.out.println("| DiscoveryClient.errMsg = " + string);
                Vector vector2 = (Vector)vector.elementAt(1);
                if (vector2 != null) {
                    for (int i = 0; i < vector2.size(); ++i) {
                        String[] stringArray = (String[])vector2.elementAt(i);
                        System.out.println("| DiscoveryClient.ipList [0] = >" + stringArray[0] + "< [1] = " + stringArray[1]);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            System.out.println("Usage: CecDiscoveryClient -target startIP endIP");
            System.out.println("                          -target is a CEC or BPA");
            System.exit(1);
        }
        CecDiscoveryClient cecDiscoveryClient = new CecDiscoveryClient();
        Vector vector = null;
        if (stringArray[0].trim().equals("CEC")) {
            vector = cecDiscoveryClient.discoverCecs(stringArray[1], stringArray[2]);
        } else if (stringArray[0].trim().equals("BPA")) {
            vector = cecDiscoveryClient.discoverFrames(stringArray[1], stringArray[2]);
        }
        if (vector != null) {
            CecDiscoveryClient.dumpDiscResults(vector);
        }
    }

    class IpData {
        int rc = 0;
        String errMsg = null;
        String n1Str = null;
        String n2Str = null;
        String n3Str = null;
        String n4Str = null;
        int n1 = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        String subNet = null;

        IpData() {
        }
    }
}

